/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.LootTableMineableCollector;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.ServerPluginConfig;
import snownee.jade.network.ServerHandshakePacket;
import snownee.jade.network.ServerPayloadContext;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeServerPlayer;

public record ClientHandshakePacket(String protocolVersion) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientHandshakePacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_CLIENT_HANDSHAKE);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientHandshakePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ClientHandshakePacket::protocolVersion, ClientHandshakePacket::new);

    public static void handle(ClientHandshakePacket message, ServerPayloadContext context) {
        context.execute(() -> {
            ServerPlayer player = context.player();
            if (!"9".equals(message.protocolVersion)) {
                String version = CommonProxy.getModVersion("jade").orElse("UNKNOWN");
                player.displayClientMessage((Component)Component.translatable((String)"jade.protocolMismatch", (Object[])new Object[]{version}), false);
                return;
            }
            ((JadeServerPlayer)player).jade$setConnected(true);
            Map<ResourceLocation, Object> configs = ServerPluginConfig.instance().values();
            List<Block> shearableBlocks = LootTableMineableCollector.getShearableBlocks();
            if (!configs.isEmpty()) {
                Jade.LOGGER.debug("Syncing config to {} ({})", (Object)player.getGameProfile().name(), (Object)player.getGameProfile().id());
            }
            List<ResourceLocation> blockProviderIds = WailaCommonRegistration.instance().blockDataProviders.mappedIds();
            List<ResourceLocation> entityProviderIds = WailaCommonRegistration.instance().entityDataProviders.mappedIds();
            CommonProxy.sendPacket(player, new ServerHandshakePacket(configs, shearableBlocks, blockProviderIds, entityProviderIds));
        });
    }

    @NotNull
    public CustomPacketPayload.Type<ClientHandshakePacket> type() {
        return TYPE;
    }
}

